array outfile = (ustfp4cswp.log)
rem New Company Elasticities 64/36 Return Weights; Total Miles; 

spool file[$outfile]

rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem 	Gas Distribution Productivity Trends and 
rem	Econometric Benchmarking:  Code
rem 	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	Date:		August 2007
rem	Client:	Ontario Energy Board
rem 	Author:	D. Hovde and S. Fenrick
rem	Period:	1994-2004

rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	1.	LOAD US TFP DATABASE
rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load file[usdata]

rem **** Changed 11/04/07 

rem Change Revenue Weights
rem Use Average of Union and Enbridge Revenue weights for TFP3
rem Union = 1; Enbridge = 2

range

set wtryn1 		= 0.3117
set wtryvrc1 	= 0.3909
set wtryvo1		= 0.2974

set wtryn2 		= 0.2898
set wtryvrc2 	= 0.6602
set wtryvo2		= 0.0500

set wtryn 		= 0.5*(wtryn1   + wtryn2  )
set wtryvrc 	= 0.5*(wtryvrc1 + wtryvrc2)
set wtryvoth	= 0.5*(wtryvo1  + wtryvo2 )

rem  ##################  Variable Key ##############################

list

rem  ###############################################################


rem --------------------------------------------------
rem  Set cosreg = 1 for COSR; set cosreg = 0 for GD
rem --------------------------------------------------

range
calc cosreg = 1

rem set runtfp = 1 and runnat = 1 for a national tfp run

calc runtfp = 1
calc runnat = 1

rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	2.	CREATE CAPITAL COST, PRICES, AND QUANTITIES
rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rem	------------------------------------------------------
rem 	Average Handy-Whitman Indexes (Use NE Customized)
rem  	-----------------------------------------------------

range 
range if[year<1988]
set hw = hwg1
range
range if[year>1987]
set hw  = (hwg1jan+hwg1jul)/2

range

rem	----------------------------------------
rem 	Levelize HW by Company
rem	----------------------------------------
range
set wkalvl = level*hw

range
set wka = wkalvl

rem 	------------------------------------------
rem 	Allocate Common Plant to Gas Additions
rem 	------------------------------------------

range
rem Change Allocator to Annual Basis
range if[plngasgr>0]
set pctgas = plngasgr/(plngasgr+plnelegr)

range
range if[id==5]
range if[year==2002]
set pctgas = pctgas[-1]
range
range if[id==5]
range if[year==2003]
set pctgas = pctgas[-1]

range
range if[id==16]
range if[year==2003]
set pctgas = pctgas[-1]

range
range if[id==41]
range if[year==2002]
set pctgas = pctgas[-1]

range
range if[id==41]
range if[year==2003]
set pctgas = pctgas[-1]

range
range if[id==43]
range if[year==2003]
set pctgas = pctgas[-1]

range
range if[id==54]
range if[year==2002]
set pctgas = pctgas[-1]

range
range if[id==54]
range if[year==2003]
set pctgas = pctgas[-1]

rem added in jan 07

range
range if[year==2004]
set pctgas = pctgas[-1]


range
set plnend = plngasgr + pctgas*plncomgr
set depend = depgas + pctgas*depcom

range
set add = gasadd + pctgas*commadd

rem	-------------------------------------------------------------
rem 	Create Triangularized-Weighted Averages (TWA) of Indexes
rem	-------------------------------------------------------------
range
range if[year<1984]
rem Create Weights for TWA 
rem Numerator
set wtNUM46 = 46 -(1983-year)
set wtNUM46 = wtNUM46<1 ? 0 : wtNUM46

rem Add Up Numerators and Sum to Get Denominator
aggregate var[wtNUM46] by[id] to[wtNUM46s] sum
rem Calculate TWA Weights
set wttwa46 = wtNUM46/wtNUM46s

rem Create product of Index Number and Weight
set wtwdx = wttwa46*wka

rem Sum Up Foregoing Products to Calculate TWA Index Number
aggregate var[wtwdx] to[wtwdxs] by[id] sum
range if[year==1983]
set wtwadx = wtwdxs
set wkatwa46 = wtwadx

rem 	------------------------------------------
rem 	Benchmark Capital Stock
rem 	------------------------------------------
range 
range if[year==1983]
set xcapey46 =  (plnend-depend)/wkatwa46

rem ***************************************************************
rem Build up Capital Stock using a Perpetual Inventory Equation
rem ***************************************************************

range 
rem	--------------------------------------------------------------
rem 	Depreciation Rate (from weighted average of depreciation rates 
rem	using gross plant weights and NARUC lives). 
rem	--------------------------------------------------------------

rem Change to OEB rates

set d46 = 0.0371

array years = (1984 1985 1986 1987 1988 1989 1990 1991 1992 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 )
foreach(i;$years) {
	range
	range if[sample==1]
	range if[year==${i}]
	set xcapey46 = xcapey46[-1]*(1-d46) + add/wka
}

rem	-------------------------------------
rem	Set Capital Price and Costs
rem	-------------------------------------


rem ***** Change 11/04/07
rem Change to 66/34 from 65/35

range
match file[rateoeb6436] key[year]
set return = rateoeb2

range 
range if[year>1984]
range if[sample==1]

set term = (return-(wka-wka[-1])/wka[-1])
set wkoth = d46*wka + wka[-1]*(term + term[-1] + term[-2] + term[-3] + term[-4])/5
set realretsm = 100*(term + term[-1] + term[-2] + term[-3] + term[-4])/5
set dwkoth = 100*log(wkoth/wkoth[-1])

rem ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
rem Cost of Service Capital 
rem ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

range
set r04a = 0
range if[year==2004]
set r04a = return
range
aggregate var[r04a] to[r04] by[id] sum

range
set r03a = 0
range if[year==2003]
set r03a = return
range
aggregate var[r03a] to[r03] by[id] sum

range
set r02a = 0
range if[year==2002]
set r02a = return
range
aggregate var[r02a] to[r02] by[id] sum

range
set r01a = 0
range if[year==2001]
set r01a = return
range
aggregate var[r01a] to[r01] by[id] sum

range
set r00a = 0
range if[year==2000]
set r00a = return
range
aggregate var[r00a] to[r00] by[id] sum

range
set r99a = 0
range if[year==1999]
set r99a = return
range
aggregate var[r99a] to[r99] by[id] sum

range
set r98a = 0
range if[year==1998]
set r98a = return
range
aggregate var[r98a] to[r98] by[id] sum

range
set r97a = 0
range if[year==1997]
set r97a = return
range
aggregate var[r97a] to[r97] by[id] sum

range
set r96a = 0
range if[year==1996]
set r96a = return
range
aggregate var[r96a] to[r96] by[id] sum

range
set r95a = 0
range if[year==1995]
set r95a = return
range
aggregate var[r95a] to[r95] by[id] sum

range
set r94a = 0
range if[year==1994]
set r94a = return
range
aggregate var[r94a] to[r94] by[id] sum

range
set r93a = 0
range if[year==1993]
set r93a = return
range
aggregate var[r93a] to[r93] by[id] sum


rem --------------------------------------------------------
rem Calculate COS Capital Service Price and Quanity Indexes
rem --------------------------------------------------------

rem Capital Quantity addition per year post benchmark year
range
range if[year>1983]
set xkadd = add/wka

rem Capital Quantity addition per year pre benchmark year
range
range if[year<1984&year>1937]
set wkai = wka*(46-(1983-year))/46
aggregate var[wkai] to[denom] by[id] sum

range
range if[year==1983]
set xkadd = (plnend-depend)/denom

range
array years = (1982 1981 1980 1979 1978 1977 1976 1975 1974 1973 1972 \
	1971 1970 1969 1968 1967 1966 1965 1964 1963 1962 1961 1960 1959 1958 \
	1957 1956 1955 1954 1953 1952 1951 1950 1949 1948 1947 1946 1945 1944)
foreach (yr;$years) {
	range
	range if[year==${yr}]
	set xkadd = xkadd[+1]
}


rem 2004 

range
set xkrem04 = 0
range if[year<2005&year>1958]

set xkrem04 = xkadd*(46-(2004 - year))/46

range
aggregate var[xkrem04] to[xk04] by[id] sum

range
set wkarem04 = 0
range if[year<2005&year>1958]

set wkrem04 = (xkrem04/xk04)*wka*r04 + (xkrem04/xk04)*wka*(1/(46-(2004-year)))
range
aggregate var[wkrem04] to[wkoth04] by[id] sum

rem 2003 

range
set xkrem03 = 0
range if[year<2004&year>1957]

set xkrem03 = xkadd*(46-(2003 - year))/46

range
aggregate var[xkrem03] to[xk03] by[id] sum

range
set wkarem03 = 0
range if[year<2004&year>1957]

set wkrem03 = (xkrem03/xk03)*wka*r03 + (xkrem03/xk03)*wka*(1/(46-(2003-year)))
range
aggregate var[wkrem03] to[wkoth03] by[id] sum


rem 2002 

range
set xkrem02 = 0
range if[year<2003&year>1956]

set xkrem02 = xkadd*(46-(2002 - year))/46

range
aggregate var[xkrem02] to[xk02] by[id] sum

range
set wkarem02 = 0
range if[year<2003&year>1956]

set wkrem02 = (xkrem02/xk02)*wka*r02 + (xkrem02/xk02)*wka*(1/(46-(2002-year)))
range
aggregate var[wkrem02] to[wkoth02] by[id] sum


rem 2001 

range
set xkrem01 = 0
range if[year<2002&year>1955]

set xkrem01 = xkadd*(46-(2001 - year))/46

range
aggregate var[xkrem01] to[xk01] by[id] sum

range
set wkarem01 = 0
range if[year<2002&year>1955]

set wkrem01 = (xkrem01/xk01)*wka*r01 + (xkrem01/xk01)*wka*(1/(46-(2001-year)))
range
aggregate var[wkrem01] to[wkoth01] by[id] sum


rem 2000 

range
set xkrem00 = 0
range if[year<2001&year>1954]

set xkrem00 = xkadd*(46-(2000 - year))/46

range
aggregate var[xkrem00] to[xk00] by[id] sum

range
set wkarem00 = 0
range if[year<2001&year>1954]

set wkrem00 = (xkrem00/xk00)*wka*r00 + (xkrem00/xk00)*wka*(1/(46-(2000-year)))
range
aggregate var[wkrem00] to[wkoth00] by[id] sum

rem 1999 

range
set xkrem99 = 0
range if[year<2000&year>1953]

set xkrem99 = xkadd*(46-(1999 - year))/46

range
aggregate var[xkrem99] to[xk99] by[id] sum

range
set wkarem99 = 0
range if[year<2000&year>1953]

set wkrem99 = (xkrem99/xk99)*wka*r99 + (xkrem99/xk99)*wka*(1/(46-(1999-year)))
range
aggregate var[wkrem99] to[wkoth99] by[id] sum

rem 1998 

range
set xkrem98 = 0
range if[year<1999&year>1952]

set xkrem98 = xkadd*(46-(1998 - year))/46

range
aggregate var[xkrem98] to[xk98] by[id] sum

range
set wkarem98 = 0
range if[year<1999&year>1952]

set wkrem98 = (xkrem98/xk98)*wka*r98 + (xkrem98/xk98)*wka*(1/(46-(1998-year)))
range
aggregate var[wkrem98] to[wkoth98] by[id] sum

rem 1997 

range
set xkrem97 = 0
range if[year<1998&year>1951]

set xkrem97 = xkadd*(46-(1997 - year))/46

range
aggregate var[xkrem97] to[xk97] by[id] sum

range
set wkarem97 = 0
range if[year<1998&year>1951]

set wkrem97 = (xkrem97/xk97)*wka*r97 + (xkrem97/xk97)*wka*(1/(46-(1997-year)))
range
aggregate var[wkrem97] to[wkoth97] by[id] sum


rem 1996 

range
set xkrem96 = 0
range if[year<1997&year>1950]

set xkrem96 = xkadd*(46-(1996 - year))/46

range
aggregate var[xkrem96] to[xk96] by[id] sum

range
set wkarem96 = 0
range if[year<1997&year>1950]

set wkrem96 = (xkrem96/xk96)*wka*r96 + (xkrem96/xk96)*wka*(1/(46-(1996-year)))
range
aggregate var[wkrem96] to[wkoth96] by[id] sum

rem 1995 

range
set xkrem95 = 0
range if[year<1996&year>1949]

set xkrem95 = xkadd*(46-(1995 - year))/46

range
aggregate var[xkrem95] to[xk95] by[id] sum

range
set wkarem95 = 0
range if[year<1996&year>1949]

set wkrem95 = (xkrem95/xk95)*wka*r95 + (xkrem95/xk95)*wka*(1/(46-(1995-year)))
range
aggregate var[wkrem95] to[wkoth95] by[id] sum


rem 1994 

range
set xkrem94 = 0
range if[year<1995&year>1948]

set xkrem94 = xkadd*(46-(1994 - year))/46

range
aggregate var[xkrem94] to[xk94] by[id] sum

range
set wkarem94 = 0
range if[year<1995&year>1948]

set wkrem94 = (xkrem94/xk94)*wka*r94 + (xkrem94/xk94)*wka*(1/(46-(1994-year)))
range
aggregate var[wkrem94] to[wkoth94] by[id] sum

rem 1993 

range
set xkrem93 = 0
range if[year<1994&year>1947]

set xkrem93 = xkadd*(46-(1993 - year))/46

range
aggregate var[xkrem93] to[xk93] by[id] sum

range
set wkarem93 = 0
range if[year<1994&year>1947]

set wkrem93 = (xkrem93/xk93)*wka*r93 + (xkrem93/xk93)*wka*(1/(46-(1993-year)))
range
aggregate var[wkrem93] to[wkoth93] by[id] sum


rem -------------------------------
rem Consolidate into one variable
rem -------------------------------


range
range if[year==2004]
set wkothcos = wkoth04
set xkcos = xk04

range
range if[year==2003]
set wkothcos = wkoth03
set xkcos = xk03

range
range if[year==2002]
set wkothcos = wkoth02
set xkcos = xk02

range
range if[year==2001]
set wkothcos = wkoth01
set xkcos = xk01

range
range if[year==2000]
set wkothcos = wkoth00
set xkcos = xk00

range
range if[year==1999]
set wkothcos = wkoth99
set xkcos = xk99

range
range if[year==1998]
set wkothcos = wkoth98
set xkcos = xk98

range
range if[year==1997]
set wkothcos = wkoth97
set xkcos = xk97

range
range if[year==1996]
set wkothcos = wkoth96
set xkcos = xk96

range
range if[year==1995]
set wkothcos = wkoth95
set xkcos = xk95

range
range if[year==1994]
set wkothcos = wkoth94
set xkcos = xk94

range
range if[year==1993]
set wkothcos = wkoth93
set xkcos = xk93

if (cosreg==1) {

	range
	set xcap46 = xkcos
	set wkoth = wkothcos
	set ckoth46 = xkcos*wkothcos
}

rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	3.	CALCULATE LABOR PRICE
rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rem	-------------------------------------------------------------------------
rem 	Determine the 4 ECI regions using the 8 geographic Regions of the Utilities
rem	-------------------------------------------------------------------------
range
range if[region==1]
set ecireg = 1

range
range if[region==2|region==4|region==5]
set ecireg = 2

range
range if[region==3]
set ecireg = 3

range 
range if[region==6|region==7|region==8]
set ecireg = 4

rem 	-----------------------------------------------------------------
rem 	Create a regionally adjusted ECI by multiplying the ECI for the 
rem 	Electric, Gas, and Sanitary Sector (National) by the ratio of 
rem 	an ECI for the Region to the corresponding ECI for 
rem 	the nation.
rem 	------------------------------------------------------------------

range
set ecisind = eciswegs
set eciind = eciegs

set ecinat = ecitcnat
set ecisnat = ecisw

range 
range if[ecireg==1]
set ecireg = ecitcne
set ecisreg = eciswne

range 
range if[ecireg==2]
set ecireg = ecitcso
set ecisreg = eciswso

range 
range if[ecireg==3]
set ecireg = ecitcmw
set ecisreg = eciswmw

range 
range if[ecireg==4]
set ecireg = ecitcwe
set ecisreg = eciswwe

range
set ecitc  = eciind*(ecireg/ecinat)
set ecisw = ecisind*(ecisreg/ecisnat)


rem 	-------------------------------------------------------------
rem 	Calculate Labor Price Using 2004 Levelization
rem 	-------------------------------------------------------------

range

set wl = ecitc
set wls = ecisw

rem 	--------------------------------------------------------------
rem 	Impute Missing Data and Exclude Certain Companies
rem 	--------------------------------------------------------------

range 
range if[id==16|id==27|id==28]
range if[year==2003]
set payrollo = payrollo[-1]*wls/wls[-1]

range 
range if[year==2004]
range if[id==8|id==18|id==41|id==30|id==31|id==48]
set payrollo = payrollo[-1]*wls/wls[-1]


rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	4.  DEFINE COST SHARES, INPUT PRICES, AND QUANTITIES
rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

range

rem	---------------------------------
rem	Calculate Labor Cost
rem	---------------------------------

set cl = (payrollo + penopmn )
set cl2 = payrollo
set cls = cl2

rem	---------------------------------
rem 	Calculate Non-Labor O&M Cost
rem	---------------------------------

set cm = (conm-cgtot-cagefrc-ctrswhl- payrollo - penopmn)

rem 	------------------------------------
rem	Calculate Capital Cost
rem 	------------------------------------

set ck =  ckoth46 + cagefrc + taxtot
set ck2 =  ckoth46

rem 	----------------------------------
rem 	Calculate O&M and Total Cost
rem	----------------------------------
set costtot = cl + cm + ck

rem -------------------------------------------------
rem Define Input Prices, Quantities, and Cost Shares
rem -------------------------------------------------

rem Labor
set wl = wl
set wls = wls
set xl = payrollo/wls

rem Other O&M
set wm = gdppi
set xm = cm/wm

rem Capital
set xk = xcap46
set wk = ck/xk

rem
rem Cost Shares
rem 

set sl = cl/costtot
set sm = cm/costtot
set sk = ck/costtot

rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	5.	DEFINE OUTPUT QUANTITY MEASURES
rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rem ======================================================================================================
rem 				Bring in Output Data 
rem ======================================================================================================

range 
range if[year>1993]

set yn = custot

range
set yv = yv05
set yvrc = yvrc05
set yvoth = yvoth05

rem ======================================================================================================
rem 				Bring in Weather Normalized Data Based on Above Data
rem ======================================================================================================

rem *************** 11/04/07 Change ****************
rem Bring in revised weather normalized R/C volumes
rem Bring in line miles index

rem Revise the weather normalization

match file[wadj1a2] key[id year] var[ayvrc]
match file[milendx2] key[id year] var[milendx2 ymdm ymtx]

range 
range if[year>1993]

rem Choose between COS and GD weights

rem Bring in Customized Elasticity Weights for Geometric Decay
rem match file[customelasticities] key[id] var[wtyn4 wtyvrc4 wtyvoth4]


rem *************** 11/16/07 Change ****************

rem Bring in Customized Elasticity Weights for Cost of Service
match file[elas_COS4] key[id] var[wtyn5 wtyv5 wtym5]

set esum = wtyn5 + wtyv5 + wtym5
set wtyn5 = wtyn5/esum
set wtyv5 = wtyv5/esum
set wtym5 = wtym5/esum

set yvrc = ayvrc

rem *************** 11/04/07 Change ****************
rem Get total yv, specify ymndx
set yv = yvrc + yvoth
set ymndx =  ymdm + ymtx

if(runtfp) {

spool file[$outfile] append


rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	6.	CALCULATE INDEXES (INDIVIDUAL AND AGGREGATED)
rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rem	------------------------------------------
rem	Individual Company Indexes
rem	------------------------------------------

range 
range if[sample==1]
set sl2 = sl / (sl+sm)
set sm2 = 1 - sl2

range
range if[sample==1]
range if[year==1994]

	set yndx2 = 1
	set yndx3 = 1
	set yndxn = 1
	set xndx = 1 
	set wndx = 1
	set tfpndx1 = 1
	set tfpndx2 = 1
	set tfpndx3 = 1	

array years = (1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 )

foreach(yr;$years) {
		range 
		range if[sample==1]
		range if[year==${yr}]

rem ******** Changed 11/04/07
rem Consolidate the Volume Data and add miles 

		rem Output Index
		set dyndx2 = wtyn5*log(yn/yn[-1])+wtyv5*log(yvrc/yvrc[-1])+wtym5*log(ymndx/ymndx[-1])
		set yndx2 = yndx2[-1]*exp(dyndx2)

		rem Output Index with tarrif weights
		set dyndx3 = wtryn*log(yn/yn[-1])+wtryvrc*log(yvrc/yvrc[-1])+wtryvoth*log(yvoth/yvoth[-1])
		set yndx3 = yndx3[-1]*exp(dyndx3)

		rem Input Price Index
		set dwndx = 0.5*(sl+sl[-1])*log(wl/wl[-1]) + \
				0.5*(sm+sm[-1])*log(wm/wm[-1]) + \
				0.5*(sk+sk[-1])*log(wk/wk[-1]) 
		set wndx = wndx[-1]*exp(dwndx)

		rem Input Quantity Index
		set dxndx = 0.5*(sl+sl[-1])*log(xl/xl[-1]) + \
				0.5*(sm+sm[-1])*log(xm/xm[-1]) + \
				0.5*(sk+sk[-1])*log(xk/xk[-1]) 
		set xndx = xndx[-1]*exp(dxndx)			

		rem Input Quantity Index
		set dxndxo = 0.5*(sl2+sl2[-1])*log(xl/xl[-1]) + \
				 0.5*(sm2+sm2[-1])*log(xm/xm[-1]) 

		rem TFP Indexes - R/C Econometric Weights
		set dtfpndx2  = dyndx2 - dxndx
		set tfpndx2 = tfpndx2[-1]*exp(dtfpndx2)

		rem TFP Indexes R/C Revenue Weights
		set dtfpndx3  = dyndx3 - dxndx
		set tfpndx3 = tfpndx3[-1]*exp(dtfpndx3)
		
		rem subindex trends
		set dyn = log(yn/yn[-1])
		set dyv = log(yv/yv[-1])
		set dyvr = log(yvrc/yvrc[-1])
		set dyvo = log(yvoth/yvoth[-1])
		set dym = log(ymndx/ymndx[-1])

		set dxl = log(xl/xl[-1])
		set dxm = log(xm/xm[-1])
		set dxk = log(xk/xk[-1])
}

echo =============================================================
echo ************ Results for Individual Companies ***************
echo =============================================================

range 
set badrc = 0
range if[year>1993]
range if[id==5|id==4|id==16]
set badrc = 1

range
range if[sample==1]
set wlpm = wl/wm
set wkpm = wk/wm
set tcpm = costtot/wm

}

rem Export Individual Company Results
range
save file[indexi4wp] var[year id region badrc tfpndx2 tfpndx3 xndx costtot cl cm ck xl xm xk sl sm sk \
  		 yndx2 yndx3 yn yv yvrc yvoth ymndx hdd cdd ur wl wk wm wlpm wkpm tcpm] if[year>1993&sample==1]

range
range if[year==2004]
range if[sample==1]
set samppeer = 1
rem Set Up Peer Group Analysis for Enbridge and Union

set dye = log(yndx2/yndx2[-10])/10
set dyr = log(yndx3/yndx3[-10])/10
set dtfpe = log(tfpndx2/tfpndx2[-10])/10
set dtfpr = log(tfpndx3/tfpndx3[-10])/10

rem Export Peer Group Data
save file[samppeer4wp] var[id year dye dyr dtfpe dtfpr esum] if[samppeer==1]

range 
set yndx = yndx2
set tfpndx = tfpndx2
set dyndx = dyndx2
set dtfpndx = dtfpndx2

set yndx2 = yndx3
set tfpndx2 = tfpndx3
set dyndx2 = dyndx3
set dtfpndx2 = dtfpndx3

rem 	---------------------------------------------------------------
rem 	Aggregate Selected Variables by Region
rem 	---------------------------------------------------------------


rem Entire Sample
range
range if[sample==1]
set region  = 0
aggregate var[yvrc yvoth costtot cl cm ck cl2 ck2 yv yn ckoth46 taxtot ymndx ] \
	to[yvr0 yvo0 c0 cl0 cm0 ck0 cl20 ck20 yv0 yn0 ckoth0 tax0 ymndx0] by[year] sum

save file[dat0] if[sample==1&year>1993] var[yvr0 yvo0 region year c0 cl0 cm0 ck0 cl20 ck20 yv0 yn0 ymndx0 ckoth0 wtyn wtyv \
			wm tax0 id costtot dxndx dxndxo dxl dxm dxk cls cm ck tfpndx tfpndx2 yndx xndx dyndx dyndx2 dyn dyv dyvr \
			dyvo dym]

clear var

rem ----------------------------------------------------------------------
rem	For Each Region: Calculate Input, Output, and TFP Indexes
rem ----------------------------------------------------------------------

array regions = ( 0 )
array years = (1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 )
foreach(r;$regions) {

	load file[dat${r}]
	
	range obs[1-2000]
	range if[region==${r}]

	set cls${r} = cl2${r}

	rem Calculate The Cost-Based LDC Weight for Each LDC Relative to the Region
	set sic  = costtot/c${r}
	set sicl = cls/cls${r}
	set sicm = cm/cm${r}
	set sick = ck/ck${r}

	rem Calculate the Product of the the LDC Weight and the LDC-specific Quantity Index Growth
	set dysic 	= 0.5*(sic+sic[-1]) * dyndx
	set dysic2 	= 0.5*(sic+sic[-1]) * dyndx2
	set dynsic 	= 0.5*(sic+sic[-1]) * dyn
	set dyvsic 	= 0.5*(sic+sic[-1]) * dyv
	set dymsic 	= 0.5*(sic+sic[-1]) * dym
	set dyvrsic	= 0.5*(sic+sic[-1]) * dyvr
	set dyvosic	= 0.5*(sic+sic[-1]) * dyvo
	set dxsic 	= 0.5*(sic+sic[-1])  * dxndx
	set dxosic 	= 0.5*(sic+sic[-1])  * dxndxo
	set dxlsicl = 0.5*(sicl+sicl[-1]) * dxl
	set dxmsicm = 0.5*(sicm+sicm[-1]) * dxm
	set dxksick = 0.5*(sick+sick[-1]) * dxk

	rem Calculate the Cost-Weighted Average of Each Index as the Sum of the Above Products
	aggregate 	var[dysic    dysic2     dynsic dyvsic dyvrsic dyvosic dxsic dxosic dxlsicl dxmsicm dxksick dymsic] \
			to[dyndx${r} dyndx2${r} dyn${r} dyv${r} dyr${r} dyo${r} dxndx${r} dxndxo${r} dxl${r} dxm${r} dxk${r} dym${r}] \
			by[year] sum
	
	rem Set the Growth in Input Price Equal to the Growth in Total Regional Cost less the Growth in Regional Input Quantity
	set dwndx${r} = log(c${r}/c${r}) - dxndx${r}

	rem Initialize the Index Values for Base Year
	range obs[1-11]
	range if[year==1994]
	set yndx${r} = 1
	set yndx2${r} = 1
	set xndx${r} = 1 
	set xndxo${r} = 1
	set xl${r} = 1
	set xm${r} = 1
	set xk${r} = 1
	set wndx${r} = 1
	set tfpndx${r} = 1
	set yr${r} = 1
	set yo${r} = 1
	set yv${r} = 1
	set ym${r} = 1
	set ynndx${r} = 1
	set pfpndxo${r} = 1

	rem For each year past the base year, calculate a Tornqvist index number using the value for 
	rem previous year and the rate of change.

	foreach(yr;$years) {
		range obs[1-11]
		range if[year==${yr}]

		rem Output Index
		set yndx${r} = yndx${r}[-1]*exp(dyndx${r})

		rem Output Index 2 
		set yndx2${r} = yndx2${r}[-1]*exp(dyndx2${r})

		rem Input Quantity Index
		set xndx${r} = xndx${r}[-1]*exp(dxndx${r})			

		rem Input Quantity Index
		set xndxo${r} = xndxo${r}[-1]*exp(dxndxo${r})		

		rem Input Quantity Index
		set wndx${r} = wndx${r}[-1]*exp(dwndx${r})	

		rem TFP Indexes
		set dtfpndx${r}  = dyndx${r} - dxndx${r}
		set tfpndx${r} = tfpndx${r}[-1]*exp(dtfpndx${r})
		set dpfpndx${r}  = dyndx${r} - dxndxo${r}
		set pfpndxo${r} = pfpndxo${r}[-1]*exp(dpfpndx${r})

		set ynndx${r} = ynndx${r}[-1]*exp(dyn${r})		
		set yr${r} = yr${r}[-1]*exp(dyr${r})
		set yo${r} = yo${r}[-1]*exp(dyo${r})
		set yv${r} = yv${r}[-1]*exp(dyv${r})
		set ym${r} = ym${r}[-1]*exp(dym${r})
		set xl${r} = xl${r}[-1]*exp(dxl${r})
		set xm${r} = xm${r}[-1]*exp(dxm${r})
		set xk${r} = xk${r}[-1]*exp(dxk${r})
	}

echo =====================================================================
echo ===================        New Region       =========================
echo =====================================================================

rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rem	7.	REPORT PRODUCTIVITY RESULTS
rem	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

echo  *************************************************************************
echo
echo	Productivity Trend Results for U.S. Natural Gas Distribution Companies
echo
echo	Output File:		$outfile
echo
echo  *************************************************************************
echo
echo

rem --------------------------------------
rem Print Results: Index Numbers and Data
rem --------------------------------------

echo ******************************************************************
echo *********************  Index Results     *************************
echo ******************************************************************
echo
	range obs[1-11]
echo				
echo *************************** Major Indexes *****************************
echo
	print var[year tfpndx${r} yndx${r} yndx2${r} xndx${r} xndxo${r} pfpndxo${r}]  
echo
echo *************************** Quantities*****************************
echo
	print var[year yn${r} yv${r} ym${r} yr${r} yo${r} xl${r} xm${r} xk${r}]

echo ******************************************************************
echo *********************  Selected Growth Rates *********************
echo ******************************************************************
echo
spool off

rem 1994-2004
range obs[11]
set tfp${r}94 = 100*log(tfpndx${r}/tfpndx${r}[-10])/10
set pfpo${r}94 = 100*log(pfpndxo${r}/pfpndxo${r}[-10])/10
set y${r}94 = 100*log(yndx${r}/yndx${r}[-10])/10
set y2${r}94 = 100*log(yndx2${r}/yndx2${r}[-10])/10
set x${r}94 = 100*log(xndx${r}/xndx${r}[-10])/10
set xl${r}94 = 100*log(xl${r}/xl${r}[-10])/10
set xm${r}94 = 100*log(xm${r}/xm${r}[-10])/10
set xk${r}94 = 100*log(xk${r}/xk${r}[-10])/10

spool file[$outfile] append

echo ***************************************************************************
echo ************************* 1994-2004 ***************************************
echo ***************************************************************************
range obs[11]
print var[tfp${r}94 pfpo${r}94 y${r}94 y2${r}94 x${r}94 ]
print var[xl${r}94 xm${r}94 xk${r}94]

clear var
}

clear

rem convert selected files to DBF format
rem 
load file[indexi4wp]
save file[indexi4wp.dbf] dbase
clear
load file[samppeer4wp]
save file[samppeer4wp.dbf] dbase
clear
load file[rateoeb6436]
save file[rateoeb6436wp.dbf] dbase
clear
load file[wadj1a2] var[ayvrc]
save file[wadj1a2wp.dbf] dbase
clear
load file[milendx2] var[milendx2 ymdm ymtx]
save file[milendx2wp.dbf] dbase
clear
load file[elas_COS4] var[wtyn5 wtyv5 wtym5]
save file[elas_COS4wp.dbf] dbase
clear
load file[usdata]
save file[usdatawp.dbf] dbase

quit
